// (c) 1999 - 2025 OneSpan North America Inc. All rights reserved.


/////////////////////////////////////////////////////////////////////////////
//
//
// This file is example source code. It is provided for your information and
// assistance. See your licence agreement for details and the terms and
// conditions of the licence which governs the use of the source code. By using
// such source code you will be accepting these terms and conditions. If you do
// not wish to accept these terms and conditions, DO NOT OPEN THE FILE OR USE
// THE SOURCE CODE.
//
// Note that there is NO WARRANTY.
//
//////////////////////////////////////////////////////////////////////////////


import Foundation

enum ConfigurableConstants {
    static let teamId = "YOUR_TEAM_ID"
    static let bundleId = "YOUR_BUNDLE_ID"
    
    // TODO: - to be provided by the integrator - `accountIdentifier`
    static let accountIdentifier = "<account identifier>"
    static let domainId = accountIdentifier.lowercased()
    static let serverCommandKey = "command"
    
    enum URLs {
        static let cloudServer = ".sdb.tid.onespan.cloud"
        static let endpoint = "https://" + accountIdentifier + cloudServer + "/v1/orchestration-commands-v2"
    }
    
    enum Salt {
        // TODO: - to be provided by the integrator - `storage` and `digipass`
        // Salts used to diversify the protection mechanisms for sensitive features.
        // Each salt should consist 64 hexadecimal characters
        static let storage = "<salt storage>"
        static let digipass = "<salt digipass>"
    }
}
